/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import com.izforge.izpack.util.OsConstraint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackFile
implements Serializable {
    static final long serialVersionUID = -834377078706854909L;
    public static final int OVERRIDE_FALSE = 0;
    public static final int OVERRIDE_TRUE = 1;
    public static final int OVERRIDE_ASK_FALSE = 2;
    public static final int OVERRIDE_ASK_TRUE = 3;
    public static final int OVERRIDE_UPDATE = 4;
    public transient String sourcePath = null;
    protected String relativePath = null;
    private String targetPath = null;
    private List<OsConstraint> osConstraints = null;
    private long length = 0L;
    private long mtime = -1L;
    private boolean isDirectory = false;
    private int override = 0;
    private Map additionals = null;
    public String previousPackId = null;
    public long offsetInPreviousPack = -1L;
    private String condition = null;

    public PackFile(File baseDir, File src, String target, List<OsConstraint> osList, int override) throws FileNotFoundException {
        this(src, PackFile.computeRelativePathFrom(baseDir, src), target, osList, override, null);
    }

    public PackFile(File src, String relativeSourcePath, String target, List<OsConstraint> osList, int override, Map additionals) throws FileNotFoundException {
        if (!src.exists()) {
            throw new FileNotFoundException("No such file: " + src);
        }
        if ('/' != File.separatorChar) {
            target = target.replace(File.separatorChar, '/');
        }
        if (target.endsWith("/")) {
            target = target.substring(0, target.length() - 1);
        }
        this.sourcePath = src.getPath();
        this.relativePath = relativeSourcePath;
        this.targetPath = target;
        this.osConstraints = osList;
        this.override = override;
        this.length = src.length();
        this.mtime = src.lastModified();
        this.isDirectory = src.isDirectory();
        this.additionals = additionals;
    }

    public PackFile(File baseDir, File src, String target, List<OsConstraint> osList, int override, Map additionals) throws FileNotFoundException {
        this(src, PackFile.computeRelativePathFrom(baseDir, src), target, osList, override, additionals);
    }

    public static String computeRelativePathFrom(File baseDir, File file) {
        if (baseDir == null || file == null) {
            return null;
        }
        try {
            if (file.getCanonicalPath().startsWith(baseDir.getCanonicalPath())) {
                return file.getCanonicalPath().substring(baseDir.getCanonicalPath().length());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return null;
    }

    public void setPreviousPackFileRef(String previousPackId, Long offsetInPreviousPack) {
        this.previousPackId = previousPackId;
        this.offsetInPreviousPack = offsetInPreviousPack;
    }

    public final List<OsConstraint> osConstraints() {
        return this.osConstraints;
    }

    public final long length() {
        return this.length;
    }

    public final long lastModified() {
        return this.mtime;
    }

    public final int override() {
        return this.override;
    }

    public final boolean isDirectory() {
        return this.isDirectory;
    }

    public final boolean isBackReference() {
        return this.previousPackId != null;
    }

    public final String getTargetPath() {
        return this.targetPath;
    }

    public String getRelativeSourcePath() {
        return this.relativePath;
    }

    public Map getAdditionals() {
        return this.additionals;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }
}

