/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.InstallerException;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecHelper {
    private String specFilename;
    private XMLElement spec;
    private boolean _haveSpec;
    public static final String YES = "yes";
    public static final String NO = "no";
    private static final String PACK_KEY = "pack";
    private static final String PACK_NAME = "name";

    public void readSpec(String specFileName) throws Exception {
        this.readSpec(specFileName, null);
    }

    public void readSpec(String specFileName, VariableSubstitutor substitutor) throws Exception {
        InputStream input = null;
        try {
            input = this.getResource(specFileName);
        }
        catch (Exception exception) {
            this._haveSpec = false;
            return;
        }
        if (input == null) {
            this._haveSpec = false;
            return;
        }
        this.readSpec(input, substitutor);
        input.close();
        this.specFilename = specFileName;
    }

    public void readSpec(InputStream input) throws Exception {
        this.readSpec(input, null);
    }

    public void readSpec(InputStream input, VariableSubstitutor substitutor) throws Exception {
        if (substitutor != null) {
            input = this.substituteVariables(input, substitutor);
        }
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setValidator(new NonValidator());
        parser.setReader(new StdXMLReader(input));
        this.spec = (XMLElement)parser.parse();
        this._haveSpec = true;
    }

    public InputStream getResource(String res) {
        try {
            return ResourceManager.getInstance().getInputStream(res);
        }
        catch (Exception e) {
            return null;
        }
    }

    public XMLElement getPackForName(String packDestName) {
        Vector<XMLElement> packs = this.getSpec().getChildrenNamed(PACK_KEY);
        Iterator<XMLElement> iter = null;
        if (packs == null) {
            return null;
        }
        for (XMLElement pack : packs) {
            String packName = pack.getAttribute(PACK_NAME);
            if (!packName.equals(packDestName)) continue;
            return pack;
        }
        return null;
    }

    public void parseError(XMLElement parent, String message) throws InstallerException {
        throw new InstallerException(this.specFilename + ":" + parent.getLineNr() + ": " + message);
    }

    public boolean haveSpec() {
        return this._haveSpec;
    }

    public XMLElement getSpec() {
        return this.spec;
    }

    public void setSpec(XMLElement element) {
        this.spec = element;
    }

    public Vector<XMLElement> getAllSubChildren(XMLElement root, String[] childdef) {
        return this.getSubChildren(root, childdef, 0);
    }

    private Vector<XMLElement> getSubChildren(XMLElement root, String[] childdef, int depth) {
        Vector<XMLElement> children;
        Vector<XMLElement> retval = null;
        Vector<XMLElement> retval2 = null;
        Vector<XMLElement> vector = children = root != null ? root.getChildrenNamed(childdef[depth]) : null;
        if (children == null) {
            return null;
        }
        if (depth < childdef.length - 1) {
            Iterator<XMLElement> iter = children.iterator();
            while (iter.hasNext()) {
                retval2 = this.getSubChildren(iter.next(), childdef, depth + 1);
                if (retval2 == null) continue;
                if (retval == null) {
                    retval = new Vector<XMLElement>();
                }
                retval.addAll(retval2);
            }
        } else {
            return children;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream substituteVariables(InputStream input, VariableSubstitutor substitutor) throws Exception {
        File tempFile = File.createTempFile("izpacksubs", "");
        FileOutputStream fos = null;
        tempFile.deleteOnExit();
        try {
            fos = new FileOutputStream(tempFile);
            substitutor.substitute(input, fos, null, "UTF-8");
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
        return new FileInputStream(tempFile);
    }

    public boolean isAttributeYes(XMLElement element, String attribute, boolean defaultValue) {
        String value = element.getAttribute(attribute, defaultValue ? YES : NO);
        if (value.equalsIgnoreCase(YES)) {
            return true;
        }
        if (value.equalsIgnoreCase(NO)) {
            return false;
        }
        return defaultValue;
    }

    public String getRequiredAttribute(XMLElement element, String attrName) throws InstallerException {
        String attr = element.getAttribute(attrName);
        if (attr == null) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attrName + "'.");
        }
        return attr;
    }
}

